package com.example.sefinsa_app.ui.clientes.fotos;

import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.ViewModelProvider;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.navigation.Navigation;

import android.os.Looper;
import android.provider.MediaStore;
import android.provider.Settings;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.RealPathUtil;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;

import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ClientesFotosGarantiasFragment extends Fragment {

    private ClientesFotosViewModel mViewModel;

    private final int CODIGO_PERMISOS_CAMARA = 1;

    private Button btnImagenesGarantias, btnImagenesComprobantes, btnImagenesGarantiasAval, btnImagenesComprobantesAval,
            btnGuardarFotos, btnUbicacion;

    private boolean camaraGarantiasClienteAbierta = false, camaraComprobantesClienteAbierta = false, camaraGarantiasAvalAbierta = false, camaraComprobantesAvalAbierta = false;

    List<MultipartBody.Part> archivosGeneral;

    private ArrayList<String> pathsGarantiasCliente;
    private ArrayList<String> pathsComprobantesCliente;
    private ArrayList<String> pathsGarantiasAval;
    private ArrayList<String> pathsComprobantesAval;

    private Cliente cliente;

    private int banderaGarantiasClientes, banderaComprobantesClientes, banderaGarantiasAvales, banderaComprobantesAvales;

    String path;

    private Uri image_uri;

    private TextView tvCliente, tvAval;

    String lat = "";
    String lgt = "";

    FusedLocationProviderClient client;

    public static ClientesFotosGarantiasFragment newInstance() {
        return new ClientesFotosGarantiasFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_clientes_fotos_garantias, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        client = LocationServices
                .getFusedLocationProviderClient(
                        getActivity());

        Bundle args = getArguments();
        String personJsonString = args.getString("cliente");
        cliente = Utils.getGsonParser().fromJson(personJsonString, Cliente.class);

        initElements(view);


    }

    private void initElements(View view) {

        CurrentFragment.fragment = "ClientesFotosGarantiasFragment";

        tvCliente = view.findViewById(R.id.tvCliente);
        tvAval = view.findViewById(R.id.tvAval);

        tvCliente.setText("Cliente " + cliente.getNombre_completo());

        pathsGarantiasCliente = new ArrayList<>();
        pathsComprobantesCliente = new ArrayList<>();
        pathsComprobantesAval = new ArrayList<>();
        pathsGarantiasAval = new ArrayList<>();

        btnImagenesGarantias = view.findViewById(R.id.btnCamaraGarantias);
        btnImagenesComprobantes = view.findViewById(R.id.btnCamaraComprobantes);
        btnImagenesGarantiasAval = view.findViewById(R.id.btnCamaraGarantiasAval);
        btnImagenesComprobantesAval = view.findViewById(R.id.btnCamaraComprobantesAval);
        btnGuardarFotos = view.findViewById(R.id.btnGuardarFotos);
        btnUbicacion = view.findViewById(R.id.btnUbicacion);

        archivosGeneral = new ArrayList<>();

        btnImagenesGarantias.setOnClickListener(view1 -> {

            int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
            int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

            if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                camaraGarantiasClienteAbierta = true;
                camaraComprobantesClienteAbierta = false;
                camaraGarantiasAvalAbierta = false;
                camaraComprobantesAvalAbierta = false;

                openCameraIntent();

            } else {
                ActivityCompat.requestPermissions(getActivity(),
                        new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                        CODIGO_PERMISOS_CAMARA);
            }
        });

        btnImagenesComprobantes.setOnClickListener(view12 -> {

            int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
            int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

            if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                camaraGarantiasClienteAbierta = false;
                camaraComprobantesClienteAbierta = true;
                camaraGarantiasAvalAbierta = false;
                camaraComprobantesAvalAbierta = false;

                openCameraIntent();

            } else {
                ActivityCompat.requestPermissions(getActivity(),
                        new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                        CODIGO_PERMISOS_CAMARA);

            }
        });

        btnImagenesComprobantesAval.setOnClickListener(view13 -> {

            int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
            int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

            if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                camaraGarantiasClienteAbierta = false;
                camaraComprobantesClienteAbierta = false;
                camaraGarantiasAvalAbierta = false;
                camaraComprobantesAvalAbierta = true;

                openCameraIntent();

            } else {
                ActivityCompat.requestPermissions(getActivity(),
                        new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                        CODIGO_PERMISOS_CAMARA);

            }
        });

        btnImagenesGarantiasAval.setOnClickListener(view14 -> {

            int permisoCamara = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CAMERA);
            int permisoAlmacen = ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.WRITE_EXTERNAL_STORAGE);

            if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                camaraGarantiasClienteAbierta = false;
                camaraComprobantesClienteAbierta = false;
                camaraGarantiasAvalAbierta = true;
                camaraComprobantesAvalAbierta = false;

                openCameraIntent();

            } else {
                ActivityCompat.requestPermissions(getActivity(),
                        new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                        CODIGO_PERMISOS_CAMARA);

            }
        });

        btnGuardarFotos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (pathsComprobantesAval.size() == 0 && pathsComprobantesCliente.size() == 0 &&
                        pathsGarantiasCliente.size() == 0 && pathsGarantiasAval.size() == 0 && lat.equals("") && lgt.equals("")) {

                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Aviso")
                            .setMessage("No se han tomado fotos para subir")
                            .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            })
                            .show();

                } else {
                    subirFotos();
                }

            }
        });

        btnUbicacion.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                getCurrentLocation();
                btnUbicacion.setText("Ubicación obtenida");

            }
        });

    }

    private void openCameraIntent() {
        ContentValues values = new ContentValues();

        values.put(MediaStore.Images.Media.TITLE, "Imagen ejemplo");
        values.put(MediaStore.Images.Media.DESCRIPTION, "Camara ejemplo");

        image_uri = getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);

        Intent i = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        i.putExtra(MediaStore.EXTRA_OUTPUT, image_uri);
        startActivityForResult(i, CODIGO_PERMISOS_CAMARA);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1) {
            if (resultCode == Activity.RESULT_OK) {
                if (camaraGarantiasClienteAbierta) {

                    path = RealPathUtil.getRealPath(getActivity(), image_uri);
                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                    pathsGarantiasCliente.add(path);

                    banderaGarantiasClientes = pathsGarantiasCliente.size() - 1;

                    Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                    Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                    File file = Utils.getBitmapFile(reduceBitmap, path);

                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                    MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_cliente_" + banderaGarantiasClientes, banderaGarantiasClientes + "GC.jpeg", requestFile);

                    archivosGeneral.add(body);

                    btnImagenesGarantias.setText("Garantías (" + pathsGarantiasCliente.size() + ")");
                }
                if (camaraComprobantesClienteAbierta) {

                    path = RealPathUtil.getRealPath(getActivity(), image_uri);
                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                    pathsComprobantesCliente.add(path);

                    banderaComprobantesClientes = pathsComprobantesCliente.size() - 1;

                    Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                    Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                    File file = Utils.getBitmapFile(reduceBitmap, path);

                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_cliente_" + banderaComprobantesClientes, banderaComprobantesClientes + "CC.jpeg", requestFile);

                    archivosGeneral.add(body);

                    btnImagenesComprobantes.setText("Comprobantes (" + pathsComprobantesCliente.size() + ")");
                }
                if (camaraComprobantesAvalAbierta) {

                    path = RealPathUtil.getRealPath(getActivity(), image_uri);
                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                    pathsComprobantesAval.add(path);

                    banderaComprobantesAvales = pathsComprobantesAval.size() - 1;

                    Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                    Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                    File file = Utils.getBitmapFile(reduceBitmap, path);

                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                    MultipartBody.Part body = MultipartBody.Part.createFormData("archivo_aval_" + banderaComprobantesAvales, banderaComprobantesAvales + "CA.jpeg", requestFile);

                    archivosGeneral.add(body);

                    btnImagenesComprobantesAval.setText("Comprobantes (" + pathsComprobantesAval.size() + ")");
                }
                if (camaraGarantiasAvalAbierta) {

                    path = RealPathUtil.getRealPath(getActivity(), image_uri);
                    Bitmap bitmap = BitmapFactory.decodeFile(path);
                    pathsGarantiasAval.add(path);

                    banderaGarantiasAvales = pathsGarantiasAval.size() - 1;

                    Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                    Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                    File file = Utils.getBitmapFile(reduceBitmap, path);

                    RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                    MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_aval_" + banderaGarantiasAvales, banderaGarantiasAvales + "GA.jpeg", requestFile);

                    archivosGeneral.add(body);

                    btnImagenesGarantiasAval.setText("Garantías (" + pathsGarantiasAval.size() + ")");
                }


            }

        }
    }

    @SuppressLint("MissingPermission")
    private void getCurrentLocation() {
        // Initialize Location manager
        LocationManager locationManager
                = (LocationManager) getActivity()
                .getSystemService(
                        Context.LOCATION_SERVICE);
        // Check condition
        if (locationManager.isProviderEnabled(
                LocationManager.GPS_PROVIDER)
                || locationManager.isProviderEnabled(
                LocationManager.NETWORK_PROVIDER)) {
            // When location service is enabled
            // Get last location
            client.getLastLocation().addOnCompleteListener(
                    new OnCompleteListener<Location>() {
                        @Override
                        public void onComplete(
                                @NonNull Task<Location> task) {

                            // Initialize location
                            Location location
                                    = task.getResult();
                            // Check condition
                            if (location != null) {
                                // When location result is not
                                // null set latitude

                                lat = String.valueOf(location.getLatitude());
                                lgt = String.valueOf(location.getLongitude());

                                Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();

                            } else {
                                // When location result is null
                                // initialize location request
                                LocationRequest locationRequest
                                        = new LocationRequest()
                                        .setPriority(
                                                LocationRequest
                                                        .PRIORITY_HIGH_ACCURACY)
                                        .setInterval(10000)
                                        .setFastestInterval(
                                                1000)
                                        .setNumUpdates(1);

                                // Initialize location call back
                                LocationCallback
                                        locationCallback
                                        = new LocationCallback() {
                                    @Override
                                    public void
                                    onLocationResult(
                                            LocationResult
                                                    locationResult) {
                                        // Initialize
                                        // location
                                        Location location1
                                                = locationResult
                                                .getLastLocation();

                                        lat = String.valueOf(location1.getLatitude());
                                        lgt = String.valueOf(location1.getLongitude());

                                        Toast.makeText(getActivity(), "Ubicación obtenida", Toast.LENGTH_SHORT).show();
                                    }
                                };

                                // Request location updates
                                client.requestLocationUpdates(
                                        locationRequest,
                                        locationCallback,
                                        Looper.myLooper());
                            }
                        }
                    });
        } else {
            // When location service is not enabled
            // open location setting
            startActivity(
                    new Intent(
                            Settings
                                    .ACTION_LOCATION_SOURCE_SETTINGS)
                            .setFlags(
                                    Intent.FLAG_ACTIVITY_NEW_TASK));
        }
    }

    public void subirFotos() {

        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

        RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);


        RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "subirFotos");
        RequestBody cliente_id = RequestBody.create(MediaType.parse("multipart/form-data"), cliente.getId());

        RequestBody cantidad_archivos_garantias_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasCliente.size() + "");
        RequestBody cantidad_archivos_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesCliente.size() + "");

        RequestBody cantidad_archivos_garantias_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasAval.size() + "");
        RequestBody cantidad_archivos_aval = RequestBody.create(MediaType.parse("multipart/form-data"), pathsComprobantesAval.size() + "");

        RequestBody latitud = RequestBody.create(MediaType.parse("multipart/form-data"), lat);
        RequestBody longitud = RequestBody.create(MediaType.parse("multipart/form-data"), lgt);
        RequestBody aval_id = RequestBody.create(MediaType.parse("multipart/form-data"),  "");
        Log.d("ARCHIVOS", archivosGeneral.toString());

        Call<ResponseMe> call = retrofitInterface.subirFotos(archivosGeneral, func,
                cliente_id,
                cantidad_archivos_garantias_cliente, cantidad_archivos_cliente,
                cantidad_archivos_garantias_aval, cantidad_archivos_aval, latitud, longitud,aval_id);
        call.enqueue(new Callback<ResponseMe>() {
            public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {

                dialog.cancel();
                if (response.isSuccessful()) {

                    Log.d("response", response.body().getMessage());

                    Toast.makeText(getActivity(), "Se han subido las imagenes del cliente y su aval", Toast.LENGTH_LONG).show();

                    dialog.cancel();

                    lat = "";
                    lgt = "";
                    btnUbicacion.setText("OBTENER UBICACIÓN");

                    Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                            .navigate(R.id.nav_clientes);


                } else {

                    try {

                        JSONObject jObjError = new JSONObject(response.errorBody().string());

                        new MaterialAlertDialogBuilder(getActivity())
                                .setTitle("Aviso")
                                .setMessage(jObjError.getString("message"))
                                .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {
                                    }
                                })
                                .show();

                    } catch (Exception e) {
                        Toast.makeText(getContext(), e.getMessage(), Toast.LENGTH_LONG).show();
                    }
                }
            }

            @Override
            public void onFailure(Call<ResponseMe> call, Throwable t) {
                dialog.cancel();
                Log.d("TAG", "onFailure: " + t.getLocalizedMessage());

            }


        });
    }

}